<?php
$mod = 'admin';

require_once '../includes/common.php';
if ($adminData['adminStatus'] != 1) Tips::error('你没有权限访问此页面', '/admin');

$title = '站长添加';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				
				<div class="row">
					<div class="col-12">
						<div class="card">
							<form>
								<div class="card-body">
									<h4 class="card_title"><?=$title?></h4>
									<div class="form-group">
										<label for="example-text-input" class="col-form-label">后台账号</label>
										<input class="form-control" type="text" name="adminUser" required autocomplete="off">
									</div>
									<div class="form-group">
										<label for="example-email-input" class="col-form-label">后台密码</label>
										<input class="form-control" type="text" name="adminPwd" required autocomplete="off">
									</div>
									<div class="form-group">
										<label for="example-tel-input" class="col-form-label">站长QQ</label>
										<input class="form-control" type="text" name="adminQq" required autocomplete="off">
									</div>
									<div class="form-group">
										<label class="col-form-label">站长等级</label>
										<select class="form-control" name="adminStatus">
											<option value="2">副站长</option>
                                            <?php if ($adminData['id'] == 1) { ?>
											<option value="1">总站长</option>
                                            <?php } ?>
										</select>
									</div>
									<div class="form-group">
										<button type="submit" class="btn btn-primary btn-block">添加</button>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>
<script>
    $('form').submit(function (){
        $.ajax({
            type:'POST',
            url:'/admin/ajax.php',
            data:$("form").serialize() + '&act=adminadd',
            dataType:'json',
            success:function (data) {
                if (data.code != 1) {
                    myalert(0, data.msg);
                } else {
                    myalert(1, data.msg);
                    setTimeout(function (){
                        location.href = '/admin/adminlist.php'
                    }, 2000);
                }
            },
            error:function () {
                myalert(0, '请求错误');
            }
        });
        return false;
    });
</script>