<?php
$mod = 'admin';

require_once '../includes/common.php';

if (empty($_GET['id'])) Tips::error('参数错误', '/admin/codelist.php');

$id = $_GET['id'];
$codeData = $adminClass->GetCode($id);

if (empty($codeData)) Tips::error('状态不存在', '/admin/codelist.php');

$title = '状态修改';

require_once './head.php';
?>

	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				
				<div class="row">
					<div class="col-12">
						<div class="card">
							<form>
								<div class="card-body">
									<h4 class="card_title"><?=$title?></h4>
									<div class="form-group">
										<label for="example-text-input" class="col-form-label">状态ID</label>
										<input class="form-control" type="text" name="id" autocomplete="off" value="<?=$codeData['id']?>" readonly>
									</div>
									<div class="form-group">
										<label for="example-text-input" class="col-form-label">状态名称</label>
										<input class="form-control" type="text" name="codeName" autocomplete="off" value="<?=$codeData['codeName']?>" required>
									</div>
                                    <div class="form-group">
                                        <label class="col-form-label">站点允许使用</label>
                                        <select class="form-control" name="siteState">
                                            <option value="0">不允许</option>
                                            <option value="1" <?=(!$codeData['siteState'])?'':'selected'?>>允许</option>
                                        </select>
                                    </div>
									<div class="form-group">
										<label for="example-tel-input" class="col-form-label">提示代码</label>
										<textarea class="form-control" name="codeHtml"><?=$codeData['codeHtml']?></textarea>
									</div>
									<div class="form-group">
										<button type="submit" class="btn btn-primary btn-block">修改</button>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>
<script>
    $('form').submit(function (){
        $.ajax({
            type:'POST',
            url:'/admin/ajax.php',
            data:$("form").serialize() + '&act=codedit',
            dataType:'json',
            success:function (data) {
                if (data.code != 1) {
                    myalert(0, data.msg);
                } else {
                    myalert(1, data.msg);
                    setTimeout(function (){
                        location.href = '/admin/codelist.php'
                    }, 2000);
                }
            },
            error:function () {
                myalert(0, '请求错误');
            }
        });
        return false;
    });
</script>