<?php
$mod = 'admin';

require_once '../includes/common.php';

$codeList = $adminClass->GetCode();

$title = '状态列表';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				
				<div class="row">
					<div class="col-12">
						<div class="card">
							<div class="card-body">
								<h4 class="card_title"><?=$title?></h4>
								<div class="single-table">
                                    <div class="table-responsive">
                                        <table id="dataTable" class="text-center table table-bordered table-hover table-striped">
                                            <thead class="bg-light text-capitalize">
                                            <tr>
                                                <th>ID</th>
                                                <th>状态名称</th>
                                                <th>站点允许使用</th>
                                                <th>操作</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($codeList as $v){ ?>
                                                <tr>
                                                    <td><?=$v['id']?></td>
                                                    <td><?=$v['codeName']?></td>
                                                    <td><?=$v['siteState'] ? '允许' : '不允许'?></td>
                                                    <td>
                                                        <a href="/admin/codeinfo.php?id=<?=$v['id']?>"><i class="ti-pencil mr-1 btn btn-success"></i></a>
                                                        <i class="ti-trash btn btn-danger" onclick="del('<?=$v['id']?>')"></i>
                                                    </td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
							</div>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>
<script>
    $(document).ready(function(){
        $('#dataTable').DataTable();
    });
    function del(id) {
        if (confirm('该状态下所有站点将被删除，确定删除?')) {
            $.ajax({
                type:'POST',
                url:'/admin/ajax.php',
                data:{
                    act:'delcode',
                    id:id
                },
                dataType:'json',
                success:function (data) {
                    if (data.code == 1) {
                        myalert(1, data.msg);
                        setTimeout(function () {
                            location.href = '/admin/codelist.php';
                        },2000)
                    } else {
                        myalert(0, data.msg);
                    }
                },
                error:function () {
                    myalert(0, '请求错误');
                }
            });
        }
    }
</script>