<?php
$mod = 'admin';

require_once '../includes/common.php';

$siteSum = $DB->query('SELECT count(*) AS sum FROM `auth_site`')->fetch(PDO::FETCH_ASSOC);
$siteSum = $siteSum['sum'];
$pirateSum = $DB->query('SELECT count(*) AS sum FROM `auth_pirate`')->fetch(PDO::FETCH_ASSOC);
$pirateSum = $pirateSum['sum'];
$userSum = $DB->query('SELECT count(*) AS sum FROM `auth_user`')->fetch(PDO::FETCH_ASSOC);
$userSum = $userSum['sum'];

$title = '授权中心';

require_once './head.php';
?>

    <div class="main-content">
        <div class="main-content-inner">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="card card-icon rt_icon_card d-flex mb-mob-4 text-center">
                            <div class="card-body">
                                <div class="icon_rt">
                                    <i class="feather ion-checkmark"></i>
                                </div>
                                <div class="icon_specs">
                                    <p>正版统计</p>
                                    <span><?=$siteSum?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="card card-icon rt_icon_card mb-mob-4 text-center">
                            <div class="card-body">
                                <div class="icon_rt">
                                    <i class="feather ion-close"></i>
                                </div>
                                <div class="icon_specs">
                                    <p>盗版统计</p>
                                    <span><?=$pirateSum?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="card card-icon rt_icon_card mb-0 text-center">
                            <div class="card-body">
                                <div class="icon_rt">
                                    <i class="feather ft-shopping-bag"></i>
                                </div>
                                <div class="icon_specs">
                                    <p>权限等级</p>
                                    <span><?=$adminStatus?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12 mt-4">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card_title">基本信息</h4>
                                <div class="single-table">
                                    <div class="table-responsive">
                                        <style>th,td{width:25%;}</style>
                                        <table class="table table-hover progress-table text-center">
                                            <tbody>
                                                <tr>
                                                    <th colspan="2">服务器软件</th>
                                                    <td colspan="2"><?=$_SERVER['SERVER_SOFTWARE']?></td>
                                                </tr>
                                                <tr>
                                                    <th>PHP版本</th>
                                                    <td><?=PHP_VERSION?></td>
                                                    <th>MYSQL版本</th>
                                                    <td><?=get_mysql($DB)?></td>
                                                </tr>
                                                <tr>
                                                    <th>操作系统</th>
                                                    <td><?=get_os()?></td>
                                                    <th>浏览器内核</th>
                                                    <td><?=get_browse()?></td>
                                                </tr>
                                                <tr>
                                                    <th>站点用户</th>
                                                    <td><?=$userSum?></td>
                                                    <th>登录IP</th>
                                                    <td><?=getIp()?></td>
                                                </tr>
                                                <tr>
                                                    <th>管理员QQ</th>
                                                    <td><?=$adminData['adminQq']?></td>
                                                    <th>QQ快捷登陆</th>
                                                    <td><?=empty($adminData['adminQqCode'])?'<a href="bindqq.php">点击绑定</a>':'已绑定 <a href="bindqq.php">重新绑定</a>'?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
<?php require_once './foot.php';?>