<?php
$mod = 'admin';

require_once '../includes/common.php';

if (empty($_GET['id'])) Tips::error('参数错误', '/admin/userlist.php');

$id = $_GET['id'];
$userData = $adminClass->GetUser($id);
$statusList = $adminClass->GetStatus();

if (empty($statusList)) Tips::error('请先添加等级', '/admin/statusadd.php');
if (empty($userData)) Tips::error('用户不存在', '/admin/userlist.php');

$title = '用户修改';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				
				<div class="row">
					<div class="col-12">
						<div class="card">
							<form>
								<div class="card-body">
									<h4 class="card_title"><?=$title?></h4>
									<div class="form-group">
										<label for="example-text-input" class="col-form-label">用户ID</label>
										<input class="form-control" type="text" name="id" required autocomplete="off" value="<?=$userData['id']?>" readonly>
									</div>
									<div class="form-group">
										<label for="example-text-input" class="col-form-label">用户账号</label>
										<input class="form-control" type="text" name="userName" required autocomplete="off" value="<?=$userData['userName']?>">
									</div>
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-form-label">用户余额</label>
                                        <input class="form-control" type="text" name="userMoney" required autocomplete="off" value="<?=$userData['userMoney']?>">
                                    </div>
									<div class="form-group">
										<label for="example-email-input" class="col-form-label">用户密码</label>
										<input class="form-control" type="text" name="userPwd" autocomplete="off" placeholder="不修改留空">
									</div>
									<div class="form-group">
										<label for="example-tel-input" class="col-form-label">用户QQ</label>
										<input class="form-control" type="text" name="userQq" required autocomplete="off" value="<?=$userData['userQq']?>">
									</div>
									<div class="form-group">
										<label class="col-form-label">用户等级</label>
										<select class="form-control" name="status">
											<?php foreach ($statusList as $v){ ?>
												<option <?=$v['id'] == $userData['statusId'] ? 'selected' : ''?> value="<?=$v['id'] . '|' . $v['statusName'] . '|' . $v['statusCode'] . '|' . $v['statusRate']?>"><?=$v['statusName']?>(<?=$v['statusCode']?> 级)</option>
											<?php } ?>
										</select>
									</div>
									<div class="form-group">
										<label class="col-form-label">用户状态</label>
										<select class="form-control" name="userState">
											<option value="1">开启</option>
											<option value="0" <?=$userData['userState'] == 0? 'selected' : ''?>>封禁</option>
										</select>
									</div>
									<div class="form-group">
										<button type="submit" class="btn btn-primary btn-block">修改</button>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>
<script>
    $('form').submit(function (){
        $.ajax({
            type:'POST',
            url:'/admin/ajax.php',
            data:$("form").serialize() + '&act=useredit',
            dataType:'json',
            success:function (data) {
                if (data.code != 1) {
                    myalert(0, data.msg);
                } else {
                    myalert(1, data.msg);
                    setTimeout(function (){
                        location.href = 'userlist.php'
                    }, 2000);
                }
            },
            error:function () {
                myalert(0, '请求错误');
            }
        });
        return false;
    });
</script>