<?php
$mod = 'admin';

require_once '../includes/common.php';

$userList = $adminClass->GetUser();

$title = '用户列表';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				
				<div class="row">
					<div class="col-12">
						<div class="card">
							<div class="card-body">
								<h4 class="card_title"><?=$title?></h4>
								<div class="single-table">
									<div class="table-responsive">
										<table id="dataTable" class="text-center table table-bordered table-hover table-striped">
											<thead class="bg-light text-capitalize">
											<tr>
												<th>ID</th>
												<th>用户账号</th>
												<th>用户QQ</th>
												<th>用户余额</th>
												<th>用户等级</th>
												<th>等级级别</th>
												<th>用户状态</th>
												<th>操作</th>
											</tr>
											</thead>
											<tbody>
											<?php foreach ($userList as $v){ ?>
												<tr>
													<td><?=$v['id']?></td>
													<td><?=$v['userName']?></td>
													<td><?=$v['userQq']?></td>
													<td><?=$v['userMoney']?> 元</td>
													<td><?=$v['statusName']?></td>
													<td><?=$v['statusCode']?> 级</td>
													<td><?=$v['userState'] ? '<span class="badge badge-success">正常</span>' : '<span class="badge badge-danger">封禁</span>'?></td>
													<td>
														<a href="/admin/userinfo.php?id=<?=$v['id']?>"><i class="ti-pencil mr-1 btn btn-success"></i></a>
														<i class="ti-trash btn btn-danger" onclick="del('<?=$v['id']?>')"></i>
													</td>
												</tr>
											<?php } ?>
											</tbody>
										</table>
									</div>
								
								</div>
							</div>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>
<script>
    $(document).ready(function(){
        $('#dataTable').DataTable();
    });
    function del(id) {
        if (confirm('确定删除?')) {
            $.ajax({
                type:'POST',
                url:'/admin/ajax.php',
                data:{
                    act:'deluser',
                    id:id
                },
                dataType:'json',
                success:function (data) {
                    if (data.code == 1) {
                        myalert(1, data.msg);
                        setTimeout(function () {
                            location.href = 'userlist.php';
                        },2000)
                    } else {
                        myalert(0, data.msg);
                    }
                },
                error:function () {
                    myalert(0, '请求错误');
                }
            });
        }
    }
</script>