/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50726
 Source Host           : localhost:3306
 Source Schema         : auth

 Target Server Type    : MySQL
 Target Server Version : 50726
 File Encoding         : 65001

 Date: 09/09/2019 09:53:04
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for auth_admin
-- ----------------------------
DROP TABLE IF EXISTS `auth_admin`;
CREATE TABLE `auth_admin`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `adminUser` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `adminPwd` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `adminQq` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `adminQqCode` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `adminStatus` tinyint(4) NULL DEFAULT 1,
  `adminLoginIp` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of auth_admin
-- ----------------------------
INSERT INTO `auth_admin` VALUES (1, 'admin', 'e10adc3949ba59abbe56e057f20f883e', 000000000, 'FD6902D7860F6B96F98D8FB0ED2DCF72', 1, '127.0.0.1');

-- ----------------------------
-- Table structure for auth_code
-- ----------------------------
DROP TABLE IF EXISTS `auth_code`;
CREATE TABLE `auth_code`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `codeName` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `siteState` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `codeHtml` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `id`(`id`, `codeName`) USING BTREE,
  INDEX `id_2`(`id`, `codeName`, `siteState`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of auth_code
-- ----------------------------
INSERT INTO `auth_code` VALUES (1, '已授权', '1', '');
INSERT INTO `auth_code` VALUES (2, '封禁', '0', '&lt;script&gt;alert(&quot;站点已被封禁&quot;);&lt;/script&gt;&lt;center style=&quot;color:red;&quot;&gt;&lt;h1&gt;授权联系QQ 000000000&lt;/h1&gt;&lt;/center&gt;');

-- ----------------------------
-- Table structure for auth_config
-- ----------------------------
DROP TABLE IF EXISTS `auth_config`;
CREATE TABLE `auth_config`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `k` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `v` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of auth_config
-- ----------------------------
INSERT INTO `auth_config` VALUES (1, 'webName', '授权站');
INSERT INTO `auth_config` VALUES (2, 'pcLogo', 'http://html.com/images/logo.svg');
INSERT INTO `auth_config` VALUES (3, 'wapLogo', 'http://html.com/images/logo.svg');
INSERT INTO `auth_config` VALUES (4, 'act', 'editconfig');
INSERT INTO `auth_config` VALUES (5, 'authPrice', '100');
INSERT INTO `auth_config` VALUES (6, 'Unauthorized', '&lt;script&gt;alert(&quot;站点未授权 授权联系QQ QQ&quot;);&lt;/script&gt;');
INSERT INTO `auth_config` VALUES (7, 'Expired', '&lt;script&gt;alert(&quot;授权已过期 授权联系QQ QQ&quot;);&lt;/script&gt;');

-- ----------------------------
-- Table structure for auth_log
-- ----------------------------
DROP TABLE IF EXISTS `auth_log`;
CREATE TABLE `auth_log`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `adminUser` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `adminIp` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `logDetail` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `logTime` datetime(0) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for auth_notice
-- ----------------------------
DROP TABLE IF EXISTS `auth_notice`;
CREATE TABLE `auth_notice`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `noticeTitle` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `noticeContent` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `noticeDate` date NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of auth_notice
-- ----------------------------
INSERT INTO `auth_notice` VALUES (1, '测试公告1', '测试公告1测试公告1测试公告1测试公告1测试公告1测试公告1测试公告1测试公告1', '2019-06-15');
INSERT INTO `auth_notice` VALUES (2, '3231231', '32131231231231231412`23123241', '2019-08-24');

-- ----------------------------
-- Table structure for auth_pirate
-- ----------------------------
DROP TABLE IF EXISTS `auth_pirate`;
CREATE TABLE `auth_pirate`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `siteUrl` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `siteAddTime` datetime(0) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for auth_site
-- ----------------------------
DROP TABLE IF EXISTS `auth_site`;
CREATE TABLE `auth_site`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `siteUrl` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `siteMail` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `siteAddTime` datetime(0) NOT NULL,
  `siteStopTime` datetime(0) NOT NULL,
  `codeId` int(11) UNSIGNED NOT NULL,
  `codeName` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `siteState` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `siteCode` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `userName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `codeId`(`codeId`, `codeName`, `siteState`) USING BTREE,
  CONSTRAINT `auth_site_ibfk_1` FOREIGN KEY (`codeId`, `codeName`, `siteState`) REFERENCES `auth_code` (`id`, `codeName`, `siteState`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of auth_site
-- ----------------------------
INSERT INTO `auth_site` VALUES (1, 'epd.com', 'QQ@qq.com', '2019-08-23 22:06:05', '2020-08-23 22:05:57', 1, '已授权', '1', '805335f6101aac3fbe31895a1c7b012c', NULL);

-- ----------------------------
-- Table structure for auth_status
-- ----------------------------
DROP TABLE IF EXISTS `auth_status`;
CREATE TABLE `auth_status`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `statusName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `statusRate` tinyint(3) UNSIGNED NOT NULL,
  `statusCode` tinyint(4) UNSIGNED NOT NULL,
  `statusMoney` decimal(10, 2) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `id`(`id`, `statusName`) USING BTREE,
  INDEX `id_2`(`id`, `statusName`, `statusCode`) USING BTREE,
  INDEX `id_3`(`id`, `statusName`, `statusCode`, `statusRate`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of auth_status
-- ----------------------------
INSERT INTO `auth_status` VALUES (1, '普通用户', 0, 1, 0.00);
INSERT INTO `auth_status` VALUES (2, '青铜代理', 10, 2, 10.00);
INSERT INTO `auth_status` VALUES (3, '白银代理', 10, 3, 20.00);
INSERT INTO `auth_status` VALUES (4, '黄金代理', 30, 4, 30.00);
INSERT INTO `auth_status` VALUES (5, '铂金代理', 40, 5, 40.00);
INSERT INTO `auth_status` VALUES (6, '钻石代理', 50, 6, 50.00);
INSERT INTO `auth_status` VALUES (7, '星耀代理', 60, 7, 60.00);
INSERT INTO `auth_status` VALUES (8, '王者代理', 70, 8, 70.00);
INSERT INTO `auth_status` VALUES (9, '荣耀代理', 80, 9, 80.00);

-- ----------------------------
-- Table structure for auth_user
-- ----------------------------
DROP TABLE IF EXISTS `auth_user`;
CREATE TABLE `auth_user`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `userName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `userPwd` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `userMoney` decimal(10, 2) NULL DEFAULT 0.00,
  `userUseMoney` decimal(10, 2) NULL DEFAULT 0.00,
  `userQq` bigint(20) UNSIGNED NOT NULL,
  `userQqCode` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `userLoginIp` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `statusId` int(11) UNSIGNED NOT NULL,
  `statusName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `statusRate` tinyint(3) UNSIGNED NOT NULL,
  `statusCode` tinyint(4) UNSIGNED NOT NULL,
  `userUpUser` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `userState` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `statusId`(`statusId`, `statusName`, `statusCode`, `statusRate`) USING BTREE,
  CONSTRAINT `auth_user_ibfk_1` FOREIGN KEY (`statusId`, `statusName`, `statusCode`, `statusRate`) REFERENCES `auth_status` (`id`, `statusName`, `statusCode`, `statusRate`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for auth_version
-- ----------------------------
DROP TABLE IF EXISTS `auth_version`;
CREATE TABLE `auth_version`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `versionCode` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `versionContent` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of auth_version
-- ----------------------------
INSERT INTO `auth_version` VALUES (1, '2.0', '1.统计API调用次数\r\n2.统计单日收益\r\n3.限制接口可开通最大容量\r\n4.获取API服务器磁盘大小防超开\r\n5.用户填写上级双方同时获得奖励\r\n6.用户消费上级可获得提成');
INSERT INTO `auth_version` VALUES (2, '2.1', '1.分销记录用户开通主机可管理\r\n2.分销可自行开通主机\r\n3.插件可开通CDN\r\n4.插件SWAPIDC WHMCS VHMS三合一通用\r\n5.对接通过密匙对接安全性大幅度提升\r\n6.用户中心以及后台中心同一账号不可异地登录\r\n7.用户可自行发布接口售卖');
INSERT INTO `auth_version` VALUES (3, '2.2', '1.后台分配接口给用户\r\n2.后台控制用户是否允许发布接口\r\n3.后台控制用户是否允许购买接口\r\n4.后台控制用户是否允许在线充值\r\n5.限制接口开通最大流量限制');
INSERT INTO `auth_version` VALUES (4, '2.3', '1.更新码支付接口\r\n2.新增调用接口单价\r\n3.修复部分浏览器无法登陆问题\r\n4.设置接口是否允许超开');
INSERT INTO `auth_version` VALUES (5, '2.5', '1.优化用户中心页面\r\n2.用户中心添加公告\r\n3.后台获取授权站公告\r\n4.后台获取版本信息\r\n5.添加首页公告功能\r\n6.后台设置客服QQ\r\n7.首页底部联系客服\r\n8.后台发布公告功能\r\n9.优化后台中心页面\r\n10.自动检测新版本');

SET FOREIGN_KEY_CHECKS = 1;
