<?php
class AdminClass
{
	public $DB;
	public $adminUser;
	
	public function __construct($DB)
	{
		$this->DB = $DB;
		$this->adminUser = empty($_SESSION['adminUser']) ? '' : $_SESSION['adminUser'];
	}
	public function Login($adminUser)
	{
		$ip = getIp();
		$_SESSION['adminUser'] = $adminUser;
		
		$this->AddLog('登录后台');
		return $this->DB->exec("UPDATE `auth_admin` SET `adminLoginIp` = '$ip' WHERE `adminUser` = '$adminUser'");
	}
	public function Logout()
	{
		unset($_SESSION['adminUser']);
	}
	public function BindQq($adminQqCode = false)
	{
		if (!$adminQqCode) Tips::error('参数错误', '-1');
		
		return $this->DB->exec("UPDATE `auth_admin` SET `adminQqCode` = '$adminQqCode' WHERE `adminUser` = '$this->adminUser'");
	}
	public function GetAdminCode($code)
	{
		return $this->DB->query("SELECT * FROM `auth_admin` WHERE `adminQqCode` = '$code'")->fetch(PDO::FETCH_ASSOC);
	}
	public function AddCode($data)
	{
		unset($data['act']);
		$sql = insertSql('auth_code', $data);
		
		$this->AddLog('添加状态--' . $data['codeName']);
		return $this->DB->exec($sql);
	}
	public function GetCode($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_code` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_code`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function DelCode($id)
	{
		$codeData = $this->GetCode($id);
		
		$this->AddLog('删除状态--' . $codeData['codeName']);
		return $this->DB->exec("DELETE FROM `auth_code` WHERE `id` = '$id'");
	}
	public function EditCode($data, $id = false)
	{
		unset($data['act']);
		$sql = updateSql('auth_code', $data);
		if ($id) $sql = updateSql('auth_code', $data, "`id` = '{$id}'");
		
		$this->AddLog('修改状态--' . $data['codeName']);
		return $this->DB->exec($sql);
	}
	public function AddSite($data)
	{
		unset($data['act']);
		$sql = insertSql('auth_site', $data);
		
		$this->AddLog('添加站点--' . $data['siteUrl']);
		return $this->DB->exec($sql);
	}
	public function GetSite($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_site` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_site`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function DelSite($id)
	{
		$siteData = $this->GetSite($id);
		
		$this->AddLog('删除站点--' . $siteData['siteUrl']);
		return $this->DB->exec("DELETE FROM `auth_site` WHERE `id` = '$id'");
	}
	public function EditSite($data, $id = false)
	{
		unset($data['act']);
		$sql = updateSql('auth_site', $data);
		if ($id) $sql = updateSql('auth_site', $data, "`id` = '{$id}'");
		
		$this->AddLog('修改站点--' . $data['siteUrl']);
		return $this->DB->exec($sql);
	}
	public function AddStatus($data)
	{
		unset($data['act']);
		$sql = insertSql('auth_status', $data);
		
		$this->AddLog('添加等级--' . $data['statusName']);
		return $this->DB->exec($sql);
	}
	public function GetStatus($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_status` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_status`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function DelStatus($id)
	{
		$statusData = $this->GetStatus($id);
		
		$this->AddLog('删除等级--' . $statusData['statusName']);
		return $this->DB->exec("DELETE FROM `auth_status` WHERE `id` = '$id'");
	}
	public function EditStatus($data, $id = false)
	{
		unset($data['act']);
		$sql = updateSql('auth_status', $data);
		if ($id) $sql = updateSql('auth_status', $data, "`id` = '{$id}'");
		
		$this->AddLog('修改等级--' . $data['statusName']);
		return $this->DB->exec($sql);
	}
	public function AddUser($data)
	{
		unset($data['act']);
		$sql = insertSql('auth_user', $data);
		
		$this->AddLog('添加用户--' . $data['userName']);
		return $this->DB->exec($sql);
	}
	public function GetUser($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_user` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_user`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function DelUser($id)
	{
		$userData = $this->GetUser($id);
		
		$this->AddLog('删除用户--' . $userData['userName']);
		return $this->DB->exec("DELETE FROM `auth_user` WHERE `id` = '$id'");
	}
	public function EditUser($data, $id = false)
	{
		unset($data['act']);
		$sql = updateSql('auth_user', $data);
		if ($id) $sql = updateSql('auth_user', $data, "`id` = '{$id}'");
		
		$this->AddLog('修改用户--' . $data['userName']);
		return $this->DB->exec($sql);
	}
	public function GetPirate($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_pirate` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_pirate`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function DelPirate($id)
	{
		$pirateData = $this->GetPirate($id);
		
		$this->AddLog('删除盗版--' . $pirateData['siteUrl']);
		return $this->DB->exec("DELETE FROM `auth_pirate` WHERE `id` = '$id'");
	}
	public function GetLog($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_log` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_log`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function AddLog($logDateil)
	{
		$data['adminUser'] = $_SESSION['adminUser'];
		$data['adminIp'] = getIp();
		$data['logDetail'] = $logDateil;
		$data['logTime'] = date('Y-m-d H:i:s');
		$sql = insertSql('auth_log', $data);
		
		$this->DB->exec($sql);
	}
	public function AddAdmin($data)
	{
		unset($data['act']);
		$sql = insertSql('auth_admin', $data);
		
		$this->AddLog('添加站长--' . $data['adminUser']);
		return $this->DB->exec($sql);
	}
	public function GetAdmin($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_admin` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_admin`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function DelAdmin($id)
	{
		$adminData = $this->GetAdmin($id);
		
		$this->AddLog('删除站长--' . $adminData['adminUser']);
		return $this->DB->exec("DELETE FROM `auth_admin` WHERE `id` = '$id'");
	}
	public function EditAdmin($data, $id = false)
	{
		unset($data['act']);
		$sql = updateSql('auth_admin', $data);
		if ($id) $sql = updateSql('auth_admin', $data, "`id` = '{$id}'");
		
		$this->AddLog('修改站长--' . $data['adminUser']);
		return $this->DB->exec($sql);
	}
	public function GetUrl($url)
	{
		return $this->DB->query("SELECT * FROM `auth_site` WHERE `siteUrl` = '$url'")->fetch(PDO::FETCH_ASSOC);
	}
	public function GetNotice($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_notice` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_notice`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function AddNotice($data)
	{
		unset($data['act']);
		
		$sql = insertSql('auth_notice', $data);
		
		$this->AddLog('添加公告--' . $data['noticeTitle']);
		return $this->DB->exec($sql);
	}
	public function DelNotice($id)
	{
		$noticeData = $this->GetNotice($id);
		
		$this->AddLog('删除公告--' . $noticeData['noticeTitle']);
		return $this->DB->exec("DELETE FROM `auth_notice` WHERE `id` = '$id'");
	}
	public function EditNotice($data, $id = false)
	{
		unset($data['act']);
		$sql = updateSql('auth_notice', $data);
		if ($id) $sql = updateSql('auth_notice', $data, "`id` = '{$id}'");
		
		$this->AddLog('修改公告--' . $data['noticeTitle']);
		return $this->DB->exec($sql);
	}
	public function GetVersion($id = false)
	{
		if ($id) return $this->DB->query("SELECT * FROM `auth_version` WHERE `id` = '$id'")->fetch(PDO::FETCH_ASSOC);
		return $this->DB->query("SELECT * FROM `auth_version`")->fetchAll(PDO::FETCH_ASSOC);
	}
	public function AddVersion($data)
	{
		unset($data['act']);
		$sql = insertSql('auth_version', $data);
		
		$this->AddLog('添加版本--' . $data['versionCode']);
		return $this->DB->exec($sql);
	}
	public function DelVersion($id)
	{
		$versionData = $this->GetVersion($id);
		
		$this->AddLog('删除版本--' . $versionData['versionCode']);
		return $this->DB->exec("DELETE FROM `auth_version` WHERE `id` = '$id'");
	}
	public function EditVersion($data, $id = false)
	{
		unset($data['act']);
		$sql = updateSql('auth_version', $data);
		if ($id) $sql = updateSql('auth_version', $data, "`id` = '{$id}'");
		
		$this->AddLog('修改版本--' . $data['versionCode']);
		return $this->DB->exec($sql);
	}
	public function DelAddPirate($siteUrl)
    {
        $this->DB->exec("DELETE FROM `auth_pirate` WHERE `siteUrl` = '$siteUrl'");
    }
}