<?php
header('Content-type:text/html;Charset=utf-8');

define('DEC', DIRECTORY_SEPARATOR);// 系统分隔符
define('ROOT_PATH', str_replace(strrchr(__DIR__, DEC), '', __DIR__) . DEC);// 根目录
define('INCLUDES_PATH', __DIR__ . DEC);// 引入目录
define('INSTALL_PATH', ROOT_PATH . 'install' . DEC);// 安装目录

require_once INCLUDES_PATH .'function.php';
require_once INCLUDES_PATH .'common.class.php';

if (!file_exists(INSTALL_PATH . '/install.lock') && $mod != 'install') Tips::error('请先安装！','/install');
if ($mod == 'install' && file_exists(INSTALL_PATH . 'install.lock'))Tips::error('已安装，重新安装请删除安装目录 install.lock 文件','-1');

require_once ROOT_PATH . 'config.php';

$dsn = 'mysql:host='.$db['dbHost'].';port='.$db['dbPort'].';dbname='.$db['dbName'].';charset=utf8';
try {
	$DB=new PDO($dsn,$db['dbUser'],$db['dbPwd']);
} catch(Exception $e) {
	Tips::error('数据库连接错误，请检查根目录 config.php 文件');
}

$allDb = $DB->query('show tables')->fetchAll(PDO::FETCH_ASSOC);
if(empty($allDb)){
	unlink(INSTALL_PATH . 'install.lock');
	if($mod != 'install')Tips::error('数据库为空，请重新安装！','/install');
}

session_start();

if($mod != 'install'){
	$isLogin = false;
	if(isset($_SESSION['adminUser'])){
		$adminUser = $_SESSION['adminUser'];
		$ip = getIp();
		
		$adminData = $DB->query("SELECT * FROM `auth_admin` WHERE `adminUser` = '$adminUser'")->fetch(PDO::FETCH_ASSOC);
		if(!empty($adminData))$isLogin = true;
	}
	if(!isset($notLogin) && $mod == 'admin' && !$isLogin)Tips::error('请先登录', '/admin/login.php');
	
	$isUserLogin = false;
	if(isset($_SESSION['userName'])){
		$userName = $_SESSION['userName'];
		$ip = getIp();
		
		$userData = $DB->query("SELECT * FROM `auth_user` WHERE `userName` = '$userName'")->fetch(PDO::FETCH_ASSOC);
		if(!empty($userData) && $userData['userLoginIp'] == $ip && $userData['userState'] == 1)$isUserLogin = true;
	}
	if(!isset($notLogin) && $mod == 'user' && !$isUserLogin)Tips::error('请先登录', '/user/login.php');
	
	$confData = $DB->query('SELECT * FROM `auth_config`')->fetchAll(PDO::FETCH_ASSOC);
	foreach ($confData as $value) {
		$conf[$value['k']] = $value['v'];
	}
}
if ($mod == 'admin') {
	require_once INCLUDES_PATH . 'class/admin.class.php';
	
	$adminClass = new AdminClass($DB);
	if (!empty($_SESSION['adminUser'])) {
	    $adminData = $DB->query("SELECT * FROM `auth_admin` WHERE `adminUser` = '$adminUser'")->fetch(PDO::FETCH_ASSOC);
        $adminStatus = $adminData['adminStatus'] == 1 ? '总站长' : '副站长' ;
    }
}
if ($mod == 'user') {
	require_once INCLUDES_PATH . 'class/user.class.php';

	$userClass = new UserClass($DB);
    if (!empty($_SESSION['userName'])) {
        $userData = $DB->query("SELECT * FROM `auth_user` WHERE `userName` = '$userName'")->fetch(PDO::FETCH_ASSOC);
        $authPrice = $conf['authPrice'] - $conf['authPrice'] * ($userData['statusRate'] / 100);
        $authPrice = $authPrice > 0 ? $authPrice : 0;
        $statusList = $userClass->GetStatus($userData['statusCode']);
    }
}
if ($mod == 'index') {
	require_once INCLUDES_PATH . 'class/index.class.php';
	
	$indexClass = new IndexClass($DB);
}
if ($mod == 'api') {
	require_once INCLUDES_PATH . 'class/api.class.php';
	
	$apiClass = new ApiClass($DB);
}

$_POST = sqlSafe($_POST);
$_GET = sqlSafe($_GET);
$_COOKIE = sqlSafe($_COOKIE);