<?php
$mod = 'index';

require_once '../includes/common.php';

$siteSum = $DB->query('SELECT count(*) AS sum FROM `auth_site`')->fetch(PDO::FETCH_ASSOC);
$siteSum = $siteSum['sum'];
$pirateSum = $DB->query('SELECT count(*) AS sum FROM `auth_pirate`')->fetch(PDO::FETCH_ASSOC);
$pirateSum = $pirateSum['sum'];
$userSum = $DB->query('SELECT count(*) AS sum FROM `auth_user`')->fetch(PDO::FETCH_ASSOC);
$userSum = $userSum['sum'];

$noticeList = $indexClass->GetNotice();

$title = '授权中心';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				<div class="row">
					<div class="col-lg-4">
						<div class="card card-icon rt_icon_card d-flex mb-mob-4 text-center">
							<div class="card-body">
								<div class="icon_rt">
									<i class="feather ion-checkmark"></i>
								</div>
								<div class="icon_specs">
									<p>正版统计</p>
									<span><?=$siteSum?></span>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="card card-icon rt_icon_card mb-mob-4 text-center">
							<div class="card-body">
								<div class="icon_rt">
									<i class="feather ion-close"></i>
								</div>
								<div class="icon_specs">
									<p>盗版统计</p>
									<span><?=$pirateSum?></span>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="card card-icon rt_icon_card mb-0 text-center">
							<div class="card-body">
								<div class="icon_rt">
									<i class="feather ion-person-stalker"></i>
								</div>
								<div class="icon_specs">
									<p>用户统计</p>
									<span><?=$userSum?></span>
								</div>
							</div>
						</div>
					</div>
				</div>

                <div class="row">
                    <!-- accordion style 4 start -->
                    <div class="col-lg-12 stretched_card mt-4">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card_title">平台公告</h4>
                                <div id="accordion3" class="accordion">
                                    <?php foreach ($noticeList as $value) { ?>
                                    <div class="card">
                                        <div class="card-header">
                                            <a class="card-link text-center" data-toggle="collapse" href="#accordian-<?=$value['id']?>">
                                                <?=$value['noticeTitle']?> (<?=$value['noticeDate']?>)
                                            </a>
                                        </div>
                                        <div id="accordian-<?=$value['id']?>" class="collapse <?=$value['id'] == $noticeList['0']['id'] ? 'show' : ''?>" data-parent="#accordion3">
                                            <div class="card-body">
												<?=htmlspecialchars_decode($value['noticeContent'])?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
		</div>
	</div>
<?php require_once './foot.php';?>