<?php
$mod = 'user';

require_once '../includes/common.php';

$siteSum = $DB->query('SELECT count(*) AS sum FROM `auth_site`')->fetch(PDO::FETCH_ASSOC);
$siteSum = $siteSum['sum'];
$pirateSum = $DB->query('SELECT count(*) AS sum FROM `auth_pirate`')->fetch(PDO::FETCH_ASSOC);
$pirateSum = $pirateSum['sum'];

$title = '授权中心';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				<div class="row">
					<div class="col-lg-4">
						<div class="card card-icon rt_icon_card d-flex mb-mob-4 text-center">
							<div class="card-body">
								<div class="icon_rt">
									<i class="feather ion-checkmark"></i>
								</div>
								<div class="icon_specs">
									<p>正版统计</p>
									<span><?=$siteSum?></span>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="card card-icon rt_icon_card mb-mob-4 text-center">
							<div class="card-body">
								<div class="icon_rt">
									<i class="feather ion-close"></i>
								</div>
								<div class="icon_specs">
									<p>盗版统计</p>
									<span><?=$pirateSum?></span>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="card card-icon rt_icon_card mb-0 text-center">
							<div class="card-body">
								<div class="icon_rt">
									<i class="feather ft-shopping-bag"></i>
								</div>
								<div class="icon_specs">
									<p>权限等级</p>
									<span><?=$userData['statusName']?></span>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-12 mt-4">
						<div class="card">
							<div class="card-body">
								<h4 class="card_title">基本信息</h4>
								<div class="single-table">
									<div class="table-responsive">
										<style>th,td{width:25%;}</style>
										<table class="table table-hover progress-table text-center">
											<tbody>
                                            <tr>
                                                <th>预存款</th>
                                                <td><?=$userData['userMoney']?> 元</td>
                                                <th>消费总额</th>
                                                <td><?=$userData['userUseMoney']?> 元</td>
                                            </tr>
                                            <tr>
                                                <th>授权单价</th>
                                                <td><?=$authPrice?> 元</td>
                                                <th>登录IP</th>
                                                <td><?=getIp()?></td>
                                            </tr>
                                            <tr>
                                                <th>用户QQ</th>
                                                <td><?=$userData['userQq']?></td>
                                                <th>QQ快捷登陆</th>
                                                <td><?=empty($userData['userQqCode'])?'<a href="bindqq.php">点击绑定</a>':'已绑定 <a href="bindqq.php">重新绑定</a>'?></td>
                                            </tr>
											<tr>
												<th>操作系统</th>
												<td><?=get_os()?></td>
												<th>浏览器内核</th>
												<td><?=get_browse()?></td>
											</tr>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>