<?php
$mod = 'user';

require_once '../includes/common.php';

$codeList = $userClass->GetCode();

if (empty($codeList)) Tips::error('请先联系管理员添加状态', '/user');

$siteStopTime = date("Y-m-d",strtotime("+1 year")) . 'T' . date('H:i:s');
$title = '站点添加';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				
				<div class="row">
					<div class="col-12">
						<div class="card">
                            <form>
                                <div class="card-body">
                                    <h4 class="card_title"><?=$title?></h4>
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-form-label">站点域名</label>
                                        <input class="form-control" type="text" name="siteUrl" required autocomplete="off">
                                    </div>
                                    <div class="form-group">
                                        <label for="example-email-input" class="col-form-label">站点邮箱</label>
                                        <input class="form-control" type="email" name="siteMail" required autocomplete="off">
                                    </div>
                                    <div class="form-group">
                                        <label for="example-tel-input" class="col-form-label">到期时间</label>
                                        <input class="form-control" type="datetime-local" name="siteStopTime" value="<?=$siteStopTime?>">
                                    </div>
                                    <div class="form-group">
                                        <label class="col-form-label">站点状态</label>
                                        <select class="form-control" name="code">
                                            <?php foreach ($codeList as $v){ ?>
                                                <option value="<?=$v['id'] . '|' . $v['codeName'] . '|' . $v['siteState']?>"><?=$v['codeName']?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary btn-block">添加</button>
                                    </div>
                                </div>
                            </form>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>
<script>
    $('form').submit(function (){
        $.ajax({
            type:'POST',
            url:'/user/ajax.php',
            data:$("form").serialize() + '&act=siteadd',
            dataType:'json',
            success:function (data) {
                if (data.code != 1) {
                    myalert(0, data.msg);
                } else {
                    myalert(1, data.msg);
                    setTimeout(function (){
                        location.href = 'sitelist.php'
                    }, 2000);
                }
            },
            error:function () {
                myalert(0, '请求错误');
            }
        });
        return false;
    });
</script>