<?php
$mod = 'user';

require_once '../includes/common.php';

if (empty($_GET['id'])) Tips::error('参数错误', '/user/sitelist.php');

$id = $_GET['id'];
$editData = $userClass->GetSite($id);
$codeList = $userClass->GetCode();

if (empty($editData)) Tips::error('该站点不存在或不属于你', '/user/sitelist.php');

$title = '站点修改';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				
				<div class="row">
					<div class="col-12">
						<div class="card">
							<form>
								<div class="card-body">
									<h4 class="card_title"><?=$title?></h4>
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-form-label">站点ID</label>
                                        <input class="form-control" type="text" name="id" required autocomplete="off" value="<?=$editData['id']?>" readonly>
                                    </div>
									<div class="form-group">
										<label for="example-text-input" class="col-form-label">站点域名</label>
										<input class="form-control" type="text" name="siteUrl" required autocomplete="off" value="<?=$editData['siteUrl']?>">
									</div>
									<div class="form-group">
										<label for="example-email-input" class="col-form-label">站点邮箱</label>
										<input class="form-control" type="email" name="siteMail" required autocomplete="off" value="<?=$editData['siteMail']?>">
									</div>
									<div class="form-group">
										<label for="example-tel-input" class="col-form-label">到期时间</label>
										<input class="form-control" type="datetime-local" name="siteStopTime" value="<?=str_replace(' ', 'T', $editData['siteStopTime'])?>">
									</div>
									<div class="form-group">
										<label class="col-form-label">站点状态</label>
										<select class="form-control" name="code">
											<?php foreach ($codeList as $v){ ?>
												<option value="<?=$v['id'] . '|' . $v['codeName'] . '|' . $v['siteState']?>" <?=$v['id'] == $editData['codeId']?'selected':''?>><?=$v['codeName']?></option>
											<?php } ?>
										</select>
									</div>
									<div class="form-group">
										<button type="submit" class="btn btn-primary btn-block">修改</button>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>
<script>
    $('form').submit(function (){
        $.ajax({
            type:'POST',
            url:'/user/ajax.php',
            data:$("form").serialize() + '&act=sitedit',
            dataType:'json',
            success:function (data) {
                if (data.code != 1) {
                    myalert(0, data.msg);
                } else {
                    myalert(1, data.msg);
                    setTimeout(function (){
                        location.href = 'sitelist.php'
                    }, 2000);
                }
            },
            error:function () {
                myalert(0, '请求错误');
            }
        });
        return false;
    });
</script>