<?php
$mod = 'user';

require_once '../includes/common.php';

if (empty($statusList)) Tips::error('你没有权限添加用户', '/user');

$title = '用户添加';

require_once './head.php';
?>
	<div class="main-content">
		<div class="main-content-inner">
			<div class="container">
				
				<div class="row">
					<div class="col-12">
						<div class="card">
							<form>
								<div class="card-body">
									<h4 class="card_title"><?=$title?></h4>
									<div class="form-group">
										<label for="example-text-input" class="col-form-label">用户账号</label>
										<input class="form-control" type="text" name="userName" required autocomplete="off">
									</div>
									<div class="form-group">
										<label for="example-email-input" class="col-form-label">用户密码</label>
										<input class="form-control" type="text" name="userPwd" required autocomplete="off">
									</div>
									<div class="form-group">
										<label for="example-tel-input" class="col-form-label">用户QQ</label>
										<input class="form-control" type="text" name="userQq" required autocomplete="off">
									</div>
									<div class="form-group">
										<label class="col-form-label">用户等级</label>
										<select class="form-control" name="status">
											<?php foreach ($statusList as $v){ ?>
												<option value="<?=$v['id'] . '|' . $v['statusName'] . '|' . $v['statusCode'] . '|' . $v['statusRate']?>"><?=$v['statusName']?>(<?=$v['statusCode']?> 级)</option>
											<?php } ?>
										</select>
									</div>
									<div class="form-group">
										<button type="submit" class="btn btn-primary btn-block">添加</button>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
<?php require_once './foot.php';?>
<script>
    $('form').submit(function (){
        $.ajax({
            type:'POST',
            url:'/user/ajax.php',
            data:$("form").serialize() + '&act=useradd',
            dataType:'json',
            success:function (data) {
                if (data.code != 1) {
                    myalert(0, data.msg);
                } else {
                    myalert(1, data.msg);
                    setTimeout(function (){
                        location.href = 'userlist.php'
                    }, 2000);
                }
            },
            error:function () {
                myalert(0, '请求错误');
            }
        });
        return false;
    });
</script>