<?php
function IMPEPD_ConfigOptions()
{
	return array(
		'空间大小' => array('Type' => 'text','Size' => '5','Description' => 'MB'),
		'数据库大小' => array('Type' => 'text','Size' => '5','Description' => 'MB'),
		'绑定域名数' => array('Type' => 'text','Size' => '5','Description' => '个，-1为无限'),
		'绑定子目录数' => array('Type' => 'text','Size' => '5','Description' => '个，0为无限'),
		'流量限制' => array('Type' => 'text','Size' => '5','Description' => 'GB/月'),
		'产品类型' => array('Type' => 'text','Size' => '5','Description' => '0为虚拟主机，1为CDN'),
		'端口(可留空)' => array('Type' => 'text','Size' => '5','Description' => '多个端口由,分开,ssl端口请加s，如80,443s')
	);
}
function IMPEPD_AdminLink($params)
{
    $act = 'AdminLink';
    $data = array(
        'apiUrl' => isset($params['product_id']) ? $params['serverdomain'] : $params['serverhostname'],
        'userName' => $params['serverusername'],
        'userKey' => $params['serverpassword']
    );
    $result = GetCloud($act, $data);

    $str = '<span class="btn btn-success btn-xs">' . $result['msg'] . '</span>';
    if($result['code'] != 1)$str = '<span class="btn btn-danger btn-xs">' . $result['msg'] . '</span>';

    return $str;
}
function IMPEPD_CheckName($params)
{
	if (!preg_match('/^[a-z0-9][a-z0-9_]{3,16}$/', $params['username']))return 'failed';
	return 'success';
}
function IMPEPD_ClientArea($params)
{
	if(isset($params['configoption25'])){
		$str1 = '<ui><form action="http://' . $params["serverip"] . ':3312/vhost/index.php?c=session&a=login" method="post" target="_blank"><input type="hidden" name="username" value="' . $params['username'] . '" /><input type="hidden" name="passwd" value="' . $params['password'] . '" /><input type="submit" class="btn btn-success btn-block" value="直接登录(自定义密码无效)"/></form>';
		$str2 = '<a href="http://' . $params["serverip"] . ':3312/vhost/?c=session&a=login" target="_blank" class="btn btn-primary btn-block">打开登录地址</a>';
		return array($str1, $str2);
	} else {
		$str = '<body onLoad="document.impepd.submit()"><form action="http://' . $params['serverip'] . ':3312/vhost/?c=session&a=login" method="POST" name="impepd"><input name="username" value="' . $params['username'] . '" hidden><input name="passwd" value="' . $params['password'] . '" hidden></form></body>';
		exit($str);
	}
}
function IMPEPD_CreateAccount($params)
{
    if (!$params['configoption6'] && ($params['configoption1'] == NULL || $params['configoption2'] == NULL)) return '容量设置错误';

    $act = 'CreateAccount';
    $data = array(
        'apiUrl' => isset($params['product_id']) ? $params['serverdomain'] : $params['serverhostname'],
        'userName' => $params['serverusername'],
        "userKey" => $params['serverpassword'],
        'apiIp' => $params['serverip'],
        'hostName' => $params['username'],
        'hostPwd' => $params['password'],
        'hostDomain' => $params['domain'],
        'hostLimit' => $params['configoption1'],
        'dbLimit' => $params['configoption2'],
        'domainLimit' => $params['configoption3'],
        'dirLimit' => $params['configoption4'],
        'flowLimit' => $params['configoption5'],
        'hostType' => $params['configoption6'],
        'prot' => $params['configoption7']
    );
    $result = GetCloud($act, $data);

    $str = 'success';
    if(isset($params['configoption25']))$str = '成功';
    if($result['code'] != 1)$str = $result['msg'];

    return $str;
}
function IMPEPD_ChangePassword($params)
{
    $act = 'ChangePassword';
    $data = array(
        'apiUrl' => isset($params['product_id']) ? $params['serverdomain'] : $params['serverhostname'],
        'userName' => $params['serverusername'],
        "userKey" => $params['serverpassword'],
        'apiIp' => $params['serverip'],
        'hostName' => $params['username'],
        'hostPwd' => $params['password']
    );

    $result = GetCloud($act, $data);

    $str = 'success';
    if(isset($params['configoption25']))$str = '成功';
    if($result['code'] != 1)$str = $result['msg'];

    return $str;
}
function IMPEPD_TerminateAccount($params)
{
    $act = 'TerminateAccount';
    $data = array(
        'apiUrl' => isset($params['product_id']) ? $params['serverdomain'] : $params['serverhostname'],
        'userName' => $params['serverusername'],
        "userKey" => $params['serverpassword'],
        'apiIp' => $params['serverip'],
        'hostName' => $params['username']
    );
    $result = GetCloud($act, $data);
print_r($data);
exit;
    $str = 'success';
    if(isset($params['configoption25']))$str = '成功';
    if($result['code'] != 1)$str = $result['msg'];

    return $str;
}
function IMPEPD_SuspendAccount($params)
{
    $act = 'SuspendAccount';
    $data = array(
        'apiUrl' => isset($params['product_id']) ? $params['serverdomain'] : $params['serverhostname'],
        'userName' => $params['serverusername'],
        "userKey" => $params['serverpassword'],
        'apiIp' => $params['serverip'],
        'hostName' => $params['username'],
        'hostState' => 1
    );
    $result = GetCloud($act, $data);

    $str = 'success';
    if(isset($params['configoption25']))$str = '成功';
    if($result['code'] != 1)$str = $result['msg'];

    return $str;
}
function IMPEPD_UnsuspendAccount($params)
{
    $act = 'SuspendAccount';
    $data = array(
        'apiUrl' => isset($params['product_id']) ? $params['serverdomain'] : $params['serverhostname'],
        'userName' => $params['serverusername'],
        "userKey" => $params['serverpassword'],
        'apiIp' => $params['serverip'],
        'hostName' => $params['username'],
        'hostState' => 0
    );
    $result = GetCloud($act, $data);

    $str = 'success';
    if(isset($params['configoption25']))$str = '成功';
    if($result['code'] != 1)$str = $result['msg'];

    return $str;
}
function GetCloud($act, $data){
    $apiUrl = $data['apiUrl'];
    unset($data['apiUrl']);
    $url = $apiUrl . '?act=' . $act;
    foreach ($data as $k => $v) {
        $url .= '&' . $k . '=' . $v;
    }
    return json_decode(file_get_contents($url), TRUE);
}
?>