<?php
if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}
use \WHMCS\Database\Capsule as Capsule;
function whmcskami_config()
{
    return array(
        'name' => 'Whmcs卡密', 
        'description' => 'Whmcs卡密插件', 
        'author' => 'Flyqie',
        'version' => '2.1',
        'fields' => array(
            'kamitips' => array(
                'FriendlyName' => '充值页面提示',
                'Type' => 'text',
                'Size' => '500',
                'Default' => '欢迎使用卡密充值系统'
            )
        )
    );
}
function whmcskami_activate()
{
    $query = "CREATE TABLE IF NOT EXISTS `mod_whmcskami` ( `id` int(255) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键', `cardkey` varchar(500) NOT NULL COMMENT '卡密内容', `status` varchar(500) NOT NULL COMMENT '卡密状态', `money` varchar(500) NOT NULL COMMENT '卡密金额', `user` varchar(500) DEFAULT NULL COMMENT '使用用户', PRIMARY KEY (`id`) ) ENGINE = MyISAM CHARSET = utf8 AUTO_INCREMENT = 0 COMMENT 'WhmcsKami插件表';";
    full_query($query);
    return array('status' => 'success','description' => '插件已经成功激活,请设置插件');
}
function whmcskami_deactivate()
{
    return array('status' => 'success','description' => '插件禁用成功,数据表未删除,请手动删除whmcskami表');
}
function whmcskami_output($vars)
{
	if($_REQUEST['action'] == 'delete_kami'){
		if(@$_REQUEST['ajax'] != 'true'){
			exit('禁止直接访问');
		}
		if(!@$_REQUEST['kamisid']){
	    	$Infoarray['result'] = 'error';
			$Infoarray['error'] = '参数不全';
			exit(json_encode($Infoarray));
		}
		$InfoFind = Capsule::table('mod_whmcskami')->where('id',$_REQUEST['kamisid'])->first();
		if(empty($InfoFind)){
	    	$Infoarray['result'] = 'error';
			$Infoarray['error'] = '无法在数据库中找到该记录';
		}else{
			$InfoRm = Capsule::table('mod_whmcskami')->where('id',$_REQUEST['kamisid'])->delete();
			if(!$InfoRm){
	    		$Infoarray['result'] = 'error';
				$Infoarray['error'] = '未知错误';
		    }else{
	    		$Infoarray['result'] = 'success';
			}
		}
		header('Content-Type: text/json; charset=utf-8');
		exit(json_encode($Infoarray));
	}elseif($_REQUEST['action'] == 'get_kami_list'){
		if(@$_REQUEST['ajax'] != 'true'){
			exit('禁止直接访问');
		}
		$kamilist = Capsule::table('mod_whmcskami')->get();
		$kamilistarray = array();
		$num = 0;
		foreach ($kamilist as $values) {
			$kamilistarray[$num]['id'] = $values->id;
			$kamilistarray[$num]['cardkey'] = $values->cardkey;
			$kamilistarray[$num]['money'] = $values->money;
			if(!$values->user){
				$kamilistarray[$num]['user'] = '无';
			}else{
				$kamilistarray[$num]['user'] = $values->user;
			}
			if($values->status == 'ok'){
				$kamilistarray[$num]['status'] = '未使用';
			}elseif($values->status == 'use'){
				$kamilistarray[$num]['status'] = '已使用';
			}else{
				$kamilistarray[$num]['status'] = '未知状态';
			}
			$kamilistarray[$num]['action'] = '<td><a class="btn btn-danger btn-xs" href="javascript:void(0)" onclick="delete_kami('.$values->id.')">删除卡密</a></td>';
			$num++;
		}
		$Infoarray['result'] = 'success';
		$Infoarray['kami'] = $kamilistarray;
		header('Content-Type: text/json; charset=utf-8');
		exit(json_encode($Infoarray));
	}elseif($_REQUEST['action'] == 'add_kami'){
		if(@$_REQUEST['ajax'] != 'true'){
			exit('禁止直接访问');
		}
		if(!@$_REQUEST['cardkey'] || !@$_REQUEST['cardmoney'] || !is_numeric(@$_REQUEST['cardmoney']) || @$_REQUEST['cardmoney'] == '0'){
	    	$Infoarray['result'] = 'error';
			$Infoarray['error'] = '参数不全或值错误';
			exit(json_encode($Infoarray));
		}
		$text = nl2br($_REQUEST['cardkey']);
        $textArr = explode("<br />",$text);
        foreach($textArr as $val){
			//去重
			$InfoFind = Capsule::table('mod_whmcskami')->where('cardkey',trim($val))->first();
			if($InfoFind){
				continue;
			}
			$InfoAdd = Capsule::table('mod_whmcskami')->insert(array('cardkey' => trim($val),'status' => 'ok','money' => trim($_REQUEST['cardmoney'])));
			if(!$InfoAdd){
				$Infoarray['result'] = 'error';
				$Infoarray['error'] = '卡密无法插入数据库';
				exit(json_encode($Infoarray));
			}
        }
		$Infoarray['result'] = 'success';
		exit(json_encode($Infoarray));
	}elseif($_REQUEST['action'] == 'gen_kami'){
		if(@$_REQUEST['ajax'] != 'true'){
			exit('禁止直接访问');
		}
		if(!@$_REQUEST['cardstart'] || !@$_REQUEST['cardlen'] || !@$_REQUEST['cardnum'] || !@$_REQUEST['cardmoney'] || !is_numeric($_REQUEST['cardlen']) || !is_numeric($_REQUEST['cardnum']) || !is_numeric(@$_REQUEST['cardmoney']) || @$_REQUEST['cardmoney'] == '0'){
	    	$Infoarray['result'] = 'error';
			$Infoarray['error'] = '参数不全或值错误';
			exit(json_encode($Infoarray));
		}
		$CardStart = trim($_REQUEST['cardstart']);
		$CardNum = $_REQUEST['cardnum'];
		$CardLen = $_REQUEST['cardlen'] - strlen($CardStart);
        for ($x=1; $x<=$CardNum; $x++) {
			$CardKey = $CardStart.whmcskami_grs($CardLen);
			//去重
			$InfoFind = Capsule::table('mod_whmcskami')->where('cardkey',$CardKey)->first();
			if($InfoFind){
				continue;
			}
	        $InfoAdd = Capsule::table('mod_whmcskami')->insert(array('cardkey' => $CardKey,'status' => 'ok','money' => trim($_REQUEST['cardmoney'])));
			if(!$InfoAdd){
				$Infoarray['result'] = 'error';
				$Infoarray['error'] = '生成第'.$x.'个卡密时无法插入数据库';
				exit(json_encode($Infoarray));
			}
        }
		$Infoarray['result'] = 'success';
		header('Content-Type: text/json; charset=utf-8');
		exit(json_encode($Infoarray));
	}elseif($_REQUEST['action'] == 'down_kami'){
		if(!@$_REQUEST['cardstatus']){
			exit('参数不全');
		}
		if($_REQUEST['cardstatus'] == 'onlyuse'){
			$infolist = Capsule::table('mod_whmcskami')->where('status','use')->get();
		    $InfoTxt = '';
		    foreach ($infolist as $values) {
		    	$InfoTxt .= $values->cardkey."\r\n";
		    }
		}elseif($_REQUEST['cardstatus'] == 'onlynouse'){
			$infolist = Capsule::table('mod_whmcskami')->where('status','ok')->get();
		    $InfoTxt = '';
		    foreach ($infolist as $values) {
		    	$InfoTxt .= $values->cardkey."\r\n";
		    }
		}elseif($_REQUEST['cardstatus'] == 'allinfo'){
			$infolist = Capsule::table('mod_whmcskami')->get();
		    $InfoTxt = '';
		    foreach ($infolist as $values) {
				if(!$values->user){
					$kmuser = '无';
				}else{
					$kmuser = $values->user;
				}
				if($values->status == 'ok'){
					$kmstatus = '未使用';
				}elseif($values->status == 'use'){
					$kmstatus = '已使用';
				}else{
					$kmstatus = $values->status;
				}
		    	$InfoTxt .= '卡密内容:'.$values->cardkey.'卡密金额:'.$values->money.'卡密状态:'.$kmstatus.'卡密使用者ID:'.$kmuser."\r\n";
		    }
		}elseif($_REQUEST['cardstatus'] == 'useallinfo'){
			$infolist = Capsule::table('mod_whmcskami')->where('status','use')->get();
		    $InfoTxt = '';
		    foreach ($infolist as $values) {
				if(!$values->user){
					$kmuser = '无';
				}else{
					$kmuser = $values->user;
				}
		    	$InfoTxt .= '卡密内容:'.$values->cardkey.'卡密金额:'.$values->money.'卡密状态:已使用'.'卡密使用者ID:'.$kmuser."\r\n";
		    }
		}elseif($_REQUEST['cardstatus'] == 'all'){
		   $infolist = Capsule::table('mod_whmcskami')->get();
		    $InfoTxt = '';
		    foreach ($infolist as $values) {
		    	$InfoTxt .= $values->cardkey."\r\n";
		    }
		}else{
	    	exit('参数不全');
		}
		if(!$InfoTxt){
			exit('数据库中没有符合条件的记录');
		}
        header ('Content-Description: File Transfer');
        header ('Content-Type: application/octet-stream');
        header ('Content-Disposition: attachment; filename=kami_list.txt');
		echo $InfoTxt;
		exit();
	}else{
		include 'templates.admin.php';
		if(@$_REQUEST['ajax'] != 'true'){
			echo $Header.PHP_EOL.$kami_management.PHP_EOL.$Footer.PHP_EOL;
		}else{
			exit($kami_management.PHP_EOL);
		}
	}
}
function whmcskami_clientarea($vars)
{
	if(@$_REQUEST['action'] != 'do_verify'){
		return array('pagetitle' => '卡密充值','requirelogin' => true,'templatefile' => 'templates/index','vars' => array('kami_tips' => $vars['kamitips']));
	}else{
		header('Content-Type: text/json; charset=utf-8');
		if(!@$_REQUEST['cardkey']){
			exit(json_encode(array('result' => 'failed','msg' => '卡密不能为空')));
		}
        if(!trim($_SESSION['uid'])){
			exit(json_encode(array('result' => 'failed','msg' => '无法获取您的用户信息,请登录后重试')));
		}
        $KamiFind = Capsule::table('mod_whmcskami')->where('cardkey',trim($_REQUEST['cardkey']))->first();
		if(!$KamiFind){
			exit(json_encode(array('result' => 'failed','msg' => '卡密不存在')));
		}
		if($KamiFind->status != 'ok'){
			exit(json_encode(array('result' => 'failed','msg' => '该卡密已经被使用')));
		}


//原版		$results = localAPI('AddCredit',array('clientid' => trim($_SESSION['uid']),'description' => '通过卡密充值加款','amount' => $KamiFind->money),Capsule::table('tbladmins')->first()->username);

  
  
  
        
//新设置       
$command = 'AddCredit';
$postData = array(
    'clientid' => trim($_SESSION['uid']),
    'description' => '通过卡密充值加款',
    'amount' => $KamiFind->money,
    'adminid' => '1',
);
//$adminUsername = Capsule::table('tbladmins')->first()->username; // Optional for WHMCS 7.2 and later
//$results = localAPI($command, $postData, $adminUsername);
$results = localAPI($command, $postData);
//print_r($results);

        

 
        
        
		if($results['result'] != 'success'){//
		    exit(json_encode(array('result' => 'failed','msg' => '余额添加失败')));
	    }else{
			$InfoUpdate = Capsule::table('mod_whmcskami')->where('cardkey',trim($_REQUEST['cardkey']))->update(array('status' => 'use','user' => trim($_SESSION['uid'])));
			if(!$InfoUpdate){
				exit(json_encode(array('result' => 'failed','msg' => '变更数据库信息时失败')));
			}
			exit(json_encode(array('result' => 'success','msg' => '恭喜,卡密已充值成功,您本次充值'.$KamiFind->money.'元,'.'账户余额'.$results['newbalance'].'元'.'感谢您的支持')));
	    }
	}
}
function whmcskami_grs($len, $chars=null)  
{  
    if (is_null($chars)) {  
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";  
    }  
    mt_srand(10000000*(double)microtime());  
    for ($i = 0, $str = '', $lc = strlen($chars)-1; $i < $len; $i++) {  
        $str .= $chars[mt_rand(0, $lc)];  
    }  
    return $str;  
}