
SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `XUE_admin`;
CREATE TABLE `XUE_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `user` varchar(20) DEFAULT NULL,
  `pass` varchar(32) DEFAULT NULL,
  `log` int(5) DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `email` varchar(30) DEFAULT NULL,
  `qq` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `XUE_rent`;
CREATE TABLE `XUE_rent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rent_cpu` varchar(30) DEFAULT NULL,
  `rent_memory` varchar(30) DEFAULT NULL,
  `rent_disk` varchar(30) DEFAULT NULL,
  `rent_ip` varchar(150) DEFAULT NULL,
  `rent_network` varchar(30) DEFAULT NULL,
  `rent_ddos` varchar(15) DEFAULT NULL,
  `rent_name` varchar(30) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `rent_day_money` decimal(10,2) DEFAULT NULL,
  `rent_month_money` decimal(10,2) DEFAULT NULL,
  `rent_year_money` decimal(10,2) DEFAULT NULL,
  `tid` int(11) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `rent_date` int(11) DEFAULT NULL,
  `rent_system` varchar(200) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `XUE_rentlog`;
CREATE TABLE `XUE_rentlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vps_id` int(11) DEFAULT NULL,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `vps_user` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_pass` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` int(5) DEFAULT NULL,
  `vps_day_money` decimal(10,2) DEFAULT NULL,
  `vps_month_money` decimal(10,2) DEFAULT NULL,
  `vps_year_money` decimal(10,2) DEFAULT NULL,
  `vps_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_cpu` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_memory` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_ip` text COLLATE utf8_unicode_ci,
  `vps_disk` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_vm` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_network` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  `endtime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `XUE_buylog`;
CREATE TABLE `XUE_buylog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `orderid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  `buy_type` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `buy_money` decimal(10,2) DEFAULT NULL,
  `buy_cp` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `buy_cpid` int(11) DEFAULT NULL,
  `buy_cp_user` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `text_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `XUE_cdn`;
CREATE TABLE `XUE_cdn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  `cdn_api_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cdn_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cdn_domain` int(11) DEFAULT NULL,
  `cdn_ddos` int(11) DEFAULT NULL,
  `cdn_cc` int(11) DEFAULT NULL,
  `cdn_flow` int(11) DEFAULT NULL,
  `cdn_day_money` decimal(10,2) DEFAULT NULL,
  `cdn_month_money` decimal(10,2) DEFAULT NULL,
  `cdn_year_money` decimal(10,2) DEFAULT NULL,
  `cdn_date` int(11) DEFAULT NULL,
  `tid` int(11) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `port` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `XUE_cdnlog`;
CREATE TABLE `XUE_cdnlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cdn_id` int(11) DEFAULT NULL,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `cdn_user` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cdn_pass` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` int(5) DEFAULT NULL,
  `cdn_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cdn_domain` int(11) DEFAULT NULL,
  `cdn_ddos` int(11) DEFAULT NULL,
  `cdn_cc` int(11) DEFAULT NULL,
  `cdn_flow` int(11) DEFAULT NULL,
  `cdn_day_money` decimal(10,2) DEFAULT NULL,
  `cdn_month_money` decimal(10,2) DEFAULT NULL,
  `cdn_year_money` decimal(10,2) DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  `endtime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `XUE_class`;
CREATE TABLE `XUE_class` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL COMMENT '类分名称',
  `class_type` varchar(255) DEFAULT NULL COMMENT '类型 host=虚拟主机 vps=vps  cdn=CDN产品',
  `date` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `XUE_host`;
CREATE TABLE `XUE_host` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  `host_api_id` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_domain` int(11) DEFAULT NULL,
  `host_domains` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_size` int(11) DEFAULT NULL,
  `host_sqltype` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_mysql` int(11) DEFAULT NULL,
  `host_site` int(11) DEFAULT NULL,
  `host_network` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_jscripts` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_htaccess` varchar(130) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_day_money` decimal(10,2) DEFAULT NULL,
  `host_month_money` decimal(10,2) DEFAULT NULL,
  `host_year_money` decimal(10,2) DEFAULT NULL,
  `host_date` int(11) DEFAULT NULL,
  `tid` int(11) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `port` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flow` int(11) DEFAULT NULL,
  `state` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `XUE_hostlog`;
CREATE TABLE `XUE_hostlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host_id` int(11) DEFAULT NULL,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `host_user` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_pass` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` int(5) DEFAULT NULL,
  `host_day_money` decimal(10,2) DEFAULT NULL,
  `host_month_money` decimal(10,2) DEFAULT NULL,
  `host_year_money` decimal(10,2) DEFAULT NULL,
  `host_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_domain` int(11) DEFAULT NULL,
  `host_domains` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_size` int(11) DEFAULT NULL,
  `host_sqltype` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_mysql` int(11) DEFAULT NULL,
  `host_site` int(11) DEFAULT NULL,
  `host_network` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_jscripts` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_htaccess` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  `endtime` int(11) DEFAULT NULL,
  `bt_siteid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `XUE_idcapi`;
CREATE TABLE `XUE_idcapi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '请求地址  API的请求地址',
  `api_uid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `api_user` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'API帐号 API ID 商户号 ID等',
  `api_pass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'API密钥 密码 KEY等',
  `api_admin` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '控制面板地址',
  `api_cpid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `api_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `XUE_login`;
CREATE TABLE `XUE_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `user` varchar(20) DEFAULT NULL,
  `pass` varchar(32) DEFAULT NULL,
  `ip` varchar(180) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  `state` int(11) DEFAULT NULL COMMENT '1=登录成功  2=失败',
  `login_type` int(11) DEFAULT NULL COMMENT '1=用户登录  2= 后台管理登录',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `XUE_pay_api`;
CREATE TABLE `XUE_pay_api` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ali_email` varchar(255) DEFAULT NULL,
  `ali_pid` varchar(255) DEFAULT NULL,
  `ali_key` varchar(255) DEFAULT NULL,
  `qq_mchid` varchar(255) DEFAULT NULL,
  `qq_key` varchar(255) DEFAULT NULL,
  `wx_mchid` varchar(255) DEFAULT NULL,
  `wx_appid` varchar(255) DEFAULT NULL,
  `wx_key` varchar(255) DEFAULT NULL,
  `wx_secret` varchar(255) DEFAULT NULL,
  `epay_url` varchar(255) DEFAULT NULL,
  `epay_pid` varchar(255) DEFAULT NULL,
  `epay_key` varchar(255) DEFAULT NULL,
  `alipay_g` text(0) DEFAULT NULL,
  `alipay_s` text(0) DEFAULT NULL,
  `alipay_appid` text(0) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `XUE_pay_log`;
CREATE TABLE `XUE_pay_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `money` decimal(10,2) DEFAULT NULL,
  `paytype` varchar(15) DEFAULT NULL,
  `state` int(5) DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  `endtime` int(11) DEFAULT NULL,
  `orders` varchar(150) DEFAULT NULL,
  `text_type` varchar(100) DEFAULT NULL COMMENT '管理员充值   在线充值',
  `ip` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `XUE_plugin`;
CREATE TABLE `XUE_plugin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` int(11) DEFAULT NULL COMMENT '1',
  `plugin_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'host  vps  cdn',
  `plugin_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `XUE_shiming_sms`;
CREATE TABLE `XUE_shiming_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `code` varchar(5) DEFAULT NULL,
  `state` int(5) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `tel` varchar(11) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `XUE_sms_temp`;
CREATE TABLE `XUE_sms_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `shimingok` text,
  `shimingno` text,
  `shimingfa` text,
  `zpass` text,
  `buycp` text,
  `xfcp` text,
  `pay` text,
  `edittel` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;


INSERT INTO `XUE_sms_temp` VALUES ('1', '1', '你提交的实名认证已经审核通过', '很抱歉你的实名认证资料审核失败', '你正在进行实名认证，你的验证码是 {code} 验证码10分钟内有效', '你正在修改密码 验证码为{code}，在10分钟内有效', '恭喜你产品购买成功\n产品名称：{cpname}\n管理帐号：{cpuser}\n管理密码：{cppass}\n购买时间：{buytime}\n到期时间：{endtime}', '恭喜你产品续费成功\n产品名称：{cpname}\n管理帐号：{cpuser}\n续费时间：{buytime}\n到期时间：{endtime}', '恭喜你充值成功 你本次充值已经处理成功', '你正在绑定新手机，你的验证码是 {code} 验证码10分钟内有效');

DROP TABLE IF EXISTS `XUE_ssr`;
CREATE TABLE `XUE_ssr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


INSERT INTO `XUE_ssr` VALUES ('1', 'vps_ad.html');
INSERT INTO `XUE_ssr` VALUES ('2', 'vps_pass.html');
INSERT INTO `XUE_ssr` VALUES ('3', 'vps_xf.html');
INSERT INTO `XUE_ssr` VALUES ('4', 'host_ad.html');
INSERT INTO `XUE_ssr` VALUES ('5', 'host_xf.html');
INSERT INTO `XUE_ssr` VALUES ('6', 'host_pass.html');
INSERT INTO `XUE_ssr` VALUES ('7', 'cdn_xf.html');
INSERT INTO `XUE_ssr` VALUES ('8', 'cdn_pass.html');
INSERT INTO `XUE_ssr` VALUES ('9', 'cdn_ad.html');


DROP TABLE IF EXISTS `XUE_system`;
CREATE TABLE `XUE_system` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `webname` varchar(150) DEFAULT NULL,
  `webtitle` varchar(150) DEFAULT NULL,
  `logo` varchar(180) DEFAULT NULL,
  `qq` varchar(11) DEFAULT NULL,
  `email` varchar(30) DEFAULT NULL,
  `tel` varchar(12) DEFAULT NULL,
  `smsuser` varchar(20) DEFAULT NULL,
  `smspass` varchar(20) DEFAULT NULL,
  `domain1` varchar(80) DEFAULT NULL,
  `domain2` varchar(80) DEFAULT NULL,
  `domain3` varchar(80) DEFAULT NULL,
  `domain4` varchar(80) DEFAULT NULL,
  `emailsmtp` varchar(80) DEFAULT NULL,
  `emailuser` varchar(80) DEFAULT NULL,
  `emailpass` varchar(80) DEFAULT NULL,
  `sitetype` int(5) DEFAULT NULL COMMENT '1=主站 否则为代理站',
  `keyworks` varchar(255) DEFAULT NULL COMMENT '关键词',
  `des` varchar(255) DEFAULT NULL COMMENT '描述',
  `foot` text,
  `icp` varchar(15) DEFAULT NULL,
  `pc` int(5) DEFAULT NULL COMMENT '1=open 2=close',
  `wap` int(5) DEFAULT NULL COMMENT '1=open 2=close',
  `admin` varchar(30) DEFAULT NULL,
  `ren` int(5) DEFAULT NULL,
  `siteopen` int(5) DEFAULT NULL,
  `payapi` int(5) DEFAULT NULL,
  `useropen` int(5) DEFAULT NULL,
  `smsopen` int(5) DEFAULT NULL,
  `emailopen` int(5) DEFAULT NULL,
  `agentopen` int(5) DEFAULT NULL,
  `admin_uid` int(11) DEFAULT NULL COMMENT '绑定的主站uid  通过此UID来获取上级',
  `alipay` int(11) DEFAULT NULL COMMENT '1=官方接口 2=易支付',
  `wxpay` int(11) DEFAULT NULL COMMENT '1=官方接口 2=易支付',
  `qqpay` int(11) DEFAULT NULL COMMENT '1=官方接口 2=易支付',
  `regmoney` decimal(10,2) DEFAULT NULL,
  `tuimoney` decimal(10,2) DEFAULT NULL,
  `beimoney` decimal(10,2) DEFAULT NULL,
  `agent_type` int(5) DEFAULT NULL COMMENT '1=预存模式  2=免预存',
  `addonid` varchar(100) DEFAULT NULL,
  `qqopen` int(5) DEFAULT NULL,
  `wxopen` int(5) DEFAULT NULL,
  `v` varchar(15) DEFAULT NULL,
  `mokuai` int(11) DEFAULT NULL,
  `hexin` int(11) DEFAULT NULL,
  `alipay2` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;





DROP TABLE IF EXISTS `XUE_temp`;
CREATE TABLE `XUE_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `temp_type` int(5) DEFAULT NULL COMMENT '1=PC 2=WAP',
  `state` int(5) DEFAULT NULL COMMENT '1=使用中 2=未使用',
  `temp_name` varchar(20) DEFAULT NULL COMMENT '板模名称',
  `temp_m` varchar(150) DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `imges` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `XUE_url`;
CREATE TABLE `XUE_url` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `webname` varchar(30) DEFAULT NULL,
  `url` varchar(180) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  `state` int(11) DEFAULT NULL,
  `target` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `XUE_url` VALUES ('1', '1', '雪花云论坛', 'http://bbs.bijieqianxi.cn', '1582442923', '1', '1');
INSERT INTO `XUE_url` VALUES ('2', '1', 'XUEIDC销售系统', 'http://bbs.bijieqianxi.cn', '1582442934', '1', '1');
INSERT INTO `XUE_url` VALUES ('3', '1', '雪花云IDC系统', 'http://bbs.bijieqianxi.cn', '1582442945', '1', '1');
INSERT INTO `XUE_url` VALUES ('4', '1', '百度一下', 'http://www.baidu.com', '1582442965', '1', '1');
INSERT INTO `XUE_url` VALUES ('5', '1', '腾讯QQ', 'http://im.qq.com', '1582442985', '1', '1');
INSERT INTO `XUE_url` VALUES ('6', '1', '淘宝网', 'http://www.taobao.com', '1582442995', '1', '1');

DROP TABLE IF EXISTS `XUE_user`;
CREATE TABLE `XUE_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `user` varchar(20) DEFAULT NULL,
  `pass` varchar(32) DEFAULT NULL,
  `qq` varchar(11) DEFAULT NULL,
  `email` varchar(20) DEFAULT NULL,
  `tel` varchar(11) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  `state` int(5) DEFAULT NULL COMMENT '1=正常  2=冻结 ',
  `money` decimal(10,2) DEFAULT NULL,
  `z_money` decimal(10,2) DEFAULT NULL,
  `ip` varchar(150) DEFAULT NULL,
  `log` int(5) DEFAULT NULL,
  `ren` int(5) DEFAULT NULL,
  `img1` varchar(255) DEFAULT NULL,
  `img2` varchar(255) DEFAULT NULL,
  `myname` varchar(30) DEFAULT NULL,
  `sfznum` varchar(30) DEFAULT NULL,
  `agent_uid` int(11) DEFAULT NULL COMMENT '绑定的代理站点ID',
  `vip_host` decimal(10,2) DEFAULT NULL COMMENT '户用折扣 7就七折 1就1折',
  `qq_openid` varchar(255) DEFAULT NULL,
  `wx_openid` varchar(255) DEFAULT NULL,
  `vip_vps` decimal(10,2) DEFAULT NULL,
  `vip_cdn` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `XUE_vps`;
CREATE TABLE `XUE_vps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  `vps_api_id` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_cpu` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_memory` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_ip` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_disk` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_vm` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_network` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_day_money` decimal(10,2) DEFAULT NULL,
  `vps_month_money` decimal(10,2) DEFAULT NULL,
  `vps_year_money` decimal(10,2) DEFAULT NULL,
  `vps_date` int(11) DEFAULT NULL,
  `tid` int(11) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `vps_system` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_bak` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `XUE_vpslog`;
CREATE TABLE `XUE_vpslog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vps_id` int(11) DEFAULT NULL,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `vps_user` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_pass` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` int(5) DEFAULT NULL,
  `vps_day_money` decimal(10,2) DEFAULT NULL,
  `vps_month_money` decimal(10,2) DEFAULT NULL,
  `vps_year_money` decimal(10,2) DEFAULT NULL,
  `vps_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_cpu` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_memory` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_ip` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_disk` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_vm` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vps_network` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  `endtime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `XUE_zpass_sms`;
CREATE TABLE `XUE_zpass_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `code` varchar(5) DEFAULT NULL,
  `state` int(5) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `tel` varchar(11) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

